﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using VA.TMP.Integration.VIMT.Vista.StateObject;
using VIMT.VIAEMRService.Messages;
using VRM.Integration.Servicebus.Core;
using VA.TMP.DataModel;


namespace VA.TMP.Integration.VIMT.Vista.PipelineSteps.GetConsultsForPatient
{
    public class GetIntegrationSettingsStep : FilterBase<GetConsultsForPatientStateObject>
    {
        public override void Execute(GetConsultsForPatientStateObject state)
        {
            var errorString = string.Format(Strings.IntegrationSettingsErrorString, "{0}", "Get Consults For Patient");
            var consultStatusString = Strings.ConsultStatus;
            var fakeResponseString = Strings.ConsultFakeType;
           
            using (var _service = new Xrm(state.OrganizationServiceProxy)) {
               var _consultstatus = _service.mcs_integrationsettingSet.FirstOrDefault(i => i.mcs_name == consultStatusString);
                if (_consultstatus == null) { throw new Exception(string.Format(errorString, consultStatusString)); }
                state.mcs_status = _consultstatus.mcs_value;

                var via_fakeresponse = _service.mcs_integrationsettingSet.FirstOrDefault(i => i.mcs_name == fakeResponseString);
                if (via_fakeresponse == null)
                {
                    state.ConsultsFakeResponseType = string.Empty;
                }
                else
                {
                    state.ConsultsFakeResponseType = via_fakeresponse.mcs_value;
                }
            }
        }
    }
}
